﻿using System;
using System.Text;
using System.Xml;

namespace AHOBPR_Job_Runner.DasXml
{
    [Serializable]
    public class Attachments
    {
        public byte[] Binary { get; set; }
        public String Description { get; set;}
        public String StandardName { get; set; } 
        public String BinaryLocationURI { get; set; }
        public String Category { get; set; }

        public Attachments()
        {
            Binary = new byte[0];
            Description = "Airborne Hazard and Open Burn Pit Assessment Questionnaire";
            StandardName = "application/pdf";
            BinaryLocationURI = "ahobpr.pdf";
            Category = "AHOBPR Self-Assessment Questionnaire";
        }

        public void GetXml(XmlWriter writer)
        {
            String prefix = "nc";
            writer.WriteStartElement(prefix, "Attachment", prefix);
            writer.WriteWhitespace("\r\n\t\t\t");

            //Binary:
            {
                writer.WriteElementString(prefix, "BinaryBase64Object", prefix, System.Convert.ToBase64String(Binary));
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //Description:
            {
                writer.WriteElementString(prefix, "BinaryDescriptionText", prefix, Description);
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //Standard Name:
            {
                writer.WriteElementString(prefix, "BinaryFormatStandardName", prefix, StandardName);
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //Uri:
            {
                writer.WriteElementString(prefix, "BinaryLocationURI", prefix, BinaryLocationURI);
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //Size:
            {
                writer.WriteElementString(prefix, "BinarySizeValue", prefix, Binary.Length.ToString());
                writer.WriteWhitespace("\r\n\t\t\t");
            }

            //Category:
            {
                writer.WriteElementString(prefix, "BinaryCategoryText", prefix, Category);
                writer.WriteWhitespace("\r\n\t\t");
            }


            writer.WriteEndElement();
            writer.WriteWhitespace("\r\n\t");
        }
    }
}
